# Additional information about imports
<!--- --------------------------------------------------------------------- --->

### Pi-hole DNS (v5 or v6) ###

To use this feature, Pi.Alert requires the password for Pi-hole. During this import, an active host is recognized by 
the fact that it has sent a DNS query to Pi-hole within the last 5 minutes. If the time of the last query was longer ago, 
the host is marked as inactive or added to the device list as an inactive new host. In isolated cases, 
Pi.Alert may repeatedly recognize a host despite it having been deleted, even though the host has long since ceased to exist. When using this importer, 
the problem may also lie with Pi-hole. The maximum number of clients to be imported can also be specified in the configuration. 
By default, this value is set to “100” and must be adjusted if necessary.

### Pi-hole DHCP. (v5 or v6) ###

To use this feature, Pi.Alert requires the password for Pi-hole. This list is primarily used for name resolution.

### Fritzbox ###

To use this feature, the Fritzbox must be configured to use a username and password. 
Since multiple users can be created on the Fritzbox, you can also create a separate account for Pi-Alert. The import queries all active hosts. 
These can be located in the guest Wi-Fi or in the standard Wi-Fi. IP-less devices such as the Fritz Powerline adapters are also detected here.

### Mikrotik ###

Pi.Alert requires a user name and password for this function. During import, the active hosts are collected from the DCHP server.

### UniFi ###

Pi.Alert requires a user name and password for this function. Active hosts are collected during import.

### OpenWRT ###

Pi.Alert requires a user name and password for this function. In addition, the “JSON-RPC” package ([link](https://github.com/openwrt/luci/wiki/JsonRpcHowTo)) must be installed on the OpenWRT device.
The active hosts are recorded during import.

### AsusWRT ###

Pi.Alert requires a user name and password for this function. Active hosts are collected during import.

### pfSense ###

Pi.Alert requires an API key for this function. This can be generated after installing the “pfSense REST API” ([link](https://pfrest.org/)) on the pfSense firewall.
To increase the speed at which inactive hosts are detected, I changed another setting within pfSense:

```
System → Advanced → System Tunables

Click on "Add"

Insert:
    Tunable: net.link.ether.inet.max_age
    Value: e.g. 600
```

The background here is how long an entry in the pfSense ARP table is valid, i.e., how long a host is flagged as “active” by pfSense. This also affects the marking of active hosts in the DHCP leases.
When importing from pfSense, all DHCP leases are imported and the active hosts are also marked as active by Pi.Alert. In addition, the hosts from the pfSense ARP table are also imported, which can include all interfaces,
even those that are not managed by a DHCP server. This means that hosts may also be detected on the “WAN” interface. For this reason, this interface is excluded by default in the Pi.Alert configuration.


## Satellite Scan ## 

arp-scan, Pi-hole DNS, Pi-hole DHCP, Mikrotik, UniFi, OpenWRT, AsusWRT



[Next (5) - Additional documents](./004.md)

[Back (3) - Settings](./002.md)

[Guide_005]:             https://raw.githubusercontent.com/leiweibau/Pi.Alert/assets/guide_005.png         "Guide_005"




