<?php
//------------------------------------------------------------------------------
//  Pi.Alert
//  Open Source Network Guard / WIFI & LAN intrusion detector
//
//  speedtest_ookla.php - Front module. Server side. Manage Devices
//------------------------------------------------------------------------------
//  leiweibau  2025+        https://github.com/leiweibau     GNU GPLv3
//------------------------------------------------------------------------------

session_start();
ini_set('max_execution_time', '60');

if ($_SESSION["login"] != 1) {
	header('Location: ../../index.php');
	exit;
}
require 'timezone.php';
require 'db.php';
require 'journal.php';
require 'language_switch.php';
require '../templates/language/' . $pia_lang_selected . '.php';

// Open DB
//$DBFILE = '../../../db/pialert.db';
OpenDB_Tools();
OpenDB();

$speedtest_binary = '../../../back/pialert_tools.py';
$speedtest_option = ' speedtest';
$supported_arch = array('i386', 'x86_64', 'armel', 'armhf', 'aarch64');
$mod = $_REQUEST['mod'];

# Checking the web page to determine the current version
# ------------------------------------------------------------------------------
function get_speedtest_link($architecture) {
	global $supported_arch;

	$url = 'https://www.speedtest.net/apps/cli';
	$ch = curl_init();

	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	$html = curl_exec($ch);
	if (curl_errno($ch)) {
		echo 'cURL error: ' . curl_error($ch);
		exit;
	}
	curl_close($ch);

	$dom = new DOMDocument();
	@$dom->loadHTML($html);
	$xpath = new DOMXPath($dom);
	$ulBlock = $xpath->query('//ul[@id="linux-flyout"]')->item(0);
	if ($ulBlock) {
		$ulHTML = $dom->saveHTML($ulBlock);
		$strippedText = $ulHTML;
		$pattern = '/https:\/\/[^\s"]+/';
		preg_match_all($pattern, $strippedText, $matches);
		$urls = $matches[0][0];
		return str_replace($supported_arch, $architecture, $urls);
	}
}

# Download the current version
# ------------------------------------------------------------------------------
function download_speedtest($link) {
	$savePath = '../../../back/speedtest/speedtest.tgz';

// Disable caching
	header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
	header('Cache-Control: post-check=0, pre-check=0', false);
	header('Pragma: no-cache');

	file_put_contents($savePath, fopen($link, 'r'));

	echo 'File downloaded successfully!';
}

# Extract archive
# ------------------------------------------------------------------------------
function extract_speedtest() {
	$archivePath = '../../../back/speedtest/';
	$archiveName = 'speedtest.tgz';
	$speedtestbinary = 'speedtest';

	if (file_exists($archivePath . $archiveName)) {
		exec('/usr/bin/tar zxvf ' . $archivePath . $archiveName . ' -C ' . $archivePath, $output);
	}
	if (file_exists($archivePath . $speedtestbinary)) {
		echo 'File extract successfully!';
	} else {echo 'File extraction failed!';}
}

# Delete archive
# ------------------------------------------------------------------------------
function delete_speedtest_archive() {
	$achivePath = '../../../back/speedtest/speedtest.tgz';

	if (file_exists($achivePath)) {
		unlink($achivePath);
	}
	if (!file_exists($achivePath)) {
		echo 'Archive deleted successfully!';
	}
}

# Start the Test if speedtest exists
# ------------------------------------------------------------------------------
if ($mod == "get") {
	echo '<h4>Speedtest (Ookla) Results</h4>';
	echo '<pre style="border: none;">';
	echo "Try to install the speedtest. Only i386, x86_64, armel, armhf and aarch64 are currently supported.\n";

	$supported_arch = array('i386', 'x86_64', 'armel', 'armhf', 'aarch64');
	$kernel_arch = exec('dpkg --print-architecture');

	if (in_array($kernel_arch, $supported_arch)) {
		# System matches one of the clients
		# -----------------------------------
		echo "Detected System Architecture: " . $kernel_arch . "\n";
		$downloadlink = get_speedtest_link($kernel_arch);
		echo "Selected Downloadlink: " . $downloadlink . "\n";
		download_speedtest($downloadlink);
		echo "\n";
		extract_speedtest();
		echo "\n";
		delete_speedtest_archive();
		echo "\n";
		$show_hint = 1;
	} elseif ($kernel_arch == "amd64") {
		# Compatible client possible
		# -----------------------------------
		echo "Detected System Architecture: " . $kernel_arch . "\n";
		$downloadlink = get_speedtest_link('x86_64');
		echo "Selected Downloadlink: " . $downloadlink . "\n";
		download_speedtest($downloadlink);
		echo "\n";
		extract_speedtest();
		echo "\n";
		delete_speedtest_archive();
		echo "\n";
		$show_hint = 1;
	} elseif ($kernel_arch == "arm64") {
		# Compatible client possible
		# -----------------------------------
		echo "Detected System Architecture: " . $kernel_arch . "\n";
		$downloadlink = get_speedtest_link('aarch64');
		echo "Selected Downloadlink: " . $downloadlink . "\n";
		download_speedtest($downloadlink);
		echo "\n";
		extract_speedtest();
		echo "\n";
		delete_speedtest_archive();
		echo "\n";
		$show_hint = 1;
	} else {
		# Compatible client possible
		# -----------------------------------
		echo "Detected System Architecture: " . $kernel_arch . "\n\n";
		echo "No client was found for the existing system architecture!!!";
		$show_hint = 0;
	}

	echo '</pre>';
	if ($show_hint == 1) {
		if (!file_exists("/opt/pialert")) {
			$post_message = $pia_lang['ookla_postinstall_note'];
		} else {
			$post_message = $pia_lang['ookla_postinstall_note_lxc'];
		}

		echo '<br><button type="button" class="btn btn-primary" onclick="location.reload();" style="font-size: 18px; width:100px;"><i class="bi bi-arrow-clockwise"></i></button>';
		// echo '<span class="text-red" style="font-size: 18px;">' . $post_message . '</span>';
	}

# Speedtest not installed
# ------------------------------------------------------------------------------
} else {
	echo '<h4>Speedtest (Ookla) Results</h4>';
	echo '<pre style="border: none;">';
	echo 'Speedtest not installed';
	echo '</pre>';
}

?>