<?php
error_reporting(E_ERROR | E_PARSE);
ini_set('display_errors', '0');
ini_set('log_errors', '1');

session_start();

if ($_SESSION["login"] != 1) {
	header('Location: ./index.php');
	exit;
}

require 'php/templates/header.php';
require 'php/server/db.php';
require 'php/server/graph.php';
require 'php/server/journal.php';

$DBFILE = '../db/pialert.db';
OpenDB();

function print_box_top_element($title) {
	echo '<div class="row">
        <div class="col-md-12">
        <div class="box">
            <div class="box-header with-border">
              <h3 class="box-title">' . $title . '</h3>
            </div>
            <div class="box-body">
              <div>';
}

function print_box_bottom_element() {
	echo '          </div>
                </div>
                <!-- /.box-body -->
              </div>
            </div>
        </div>';
}

// Get Online Graph Arrays
$graph_arrays = array();
$graph_arrays = prepare_icmpscan_graph_history();
$Graph_Device_Time = $graph_arrays[0];
$Graph_Device_Down = $graph_arrays[1];
$Graph_Device_All = $graph_arrays[2];
$Graph_Device_Online = $graph_arrays[3];
$Graph_Device_Arch = $graph_arrays[4];
?>

<!-- Page ------------------------------------------------------------------ -->

<div class="content-wrapper">

<?php
// ################### Start Bulk-Editor #######################################
if ($_REQUEST['mod'] == 'bulkedit') {
	require 'php/templates/notification.php';

	echo '<section class="content-header">
          <h1 id="pageTitle">' . $pia_lang['ICMPMonitor_Title'] . ' - ' . $pia_lang['Device_bulkEditor_mode'] . '</h1>
          <a href="./icmpmonitor.php" class="btn btn-success pull-right bulk_editor_quit" role="button">' . $pia_lang['Device_bulkEditor_mode_quit'] . '</a>
        </section>';

	echo '<section class="content">
        <script src="lib/AdminLTE/bower_components/jquery/dist/jquery.min.js"></script>
        <link rel="stylesheet" href="lib/AdminLTE/plugins/iCheck/all.css">';

	if ($_REQUEST['savedata'] == 'yes') {

		$sql_queue = array();

		if ($_REQUEST['en_bulk_owner'] == 'on') {
			$set_bulk_owner = htmlspecialchars($_REQUEST['bulk_owner'], ENT_QUOTES);
			array_push($sql_queue, 'icmp_owner="' . $set_bulk_owner . '"');
		}
		if ($_REQUEST['en_bulk_type'] == 'on') {
			$set_bulk_type = htmlspecialchars($_REQUEST['bulk_type'], ENT_QUOTES);
			array_push($sql_queue, 'icmp_type="' . $set_bulk_type . '"');
		}
		if ($_REQUEST['en_bulk_group'] == 'on') {
			$set_bulk_group = htmlspecialchars($_REQUEST['bulk_group'], ENT_QUOTES);
			array_push($sql_queue, 'icmp_group="' . $set_bulk_group . '"');
		}
		if ($_REQUEST['en_bulk_location'] == 'on') {
			$set_bulk_location = htmlspecialchars($_REQUEST['bulk_location'], ENT_QUOTES);
			array_push($sql_queue, 'icmp_location="' . $set_bulk_location . '"');
		}
		if ($_REQUEST['en_bulk_comments'] == 'on') {
			$set_bulk_comments = htmlspecialchars($_REQUEST['bulk_comments'], ENT_QUOTES);
			array_push($sql_queue, 'icmp_Notes="' . $set_bulk_comments . '"');
		}
		if ($_REQUEST['en_bulk_AlertAllEvents'] == 'on') {
			if ($_REQUEST['bulk_AlertAllEvents'] == 'on') {$set_bulk_AlertAllEvents = 1;} else { $set_bulk_AlertAllEvents = 0;}
			array_push($sql_queue, 'icmp_AlertEvents="' . $set_bulk_AlertAllEvents . '"');
		}
		if ($_REQUEST['en_bulk_AlertDown'] == 'on') {
			if ($_REQUEST['bulk_AlertDown'] == 'on') {$set_bulk_AlertDown = 1;} else { $set_bulk_AlertDown = 0;}
			array_push($sql_queue, 'icmp_AlertDown="' . $set_bulk_AlertDown . '"');
		}

		print_box_top_element($pia_lang['Device_bulkEditor_savebox_title']);
		// Count changed fields
		if (sizeof($sql_queue) < 1) {
			// No fields were selected for modification
			echo '<br>' . $pia_lang['Device_bulkEditor_savebox_noselection'] . '<br>&nbsp;';
		} else {
			// Fields were selected for modification
			echo '<h4>' . $pia_lang['Device_bulkEditor_savebox_mod_devices'] . ':</h4>';
			// Prepare Update Segment start
			$sql_modified_hosts = array();
			$sql = 'SELECT icmp_hostname, icmp_ip FROM ICMP_Mon ORDER BY icmp_hostname COLLATE NOCASE ASC';
			$results = $db->query($sql);
			while ($row = $results->fetchArray()) {
				if (isset($_REQUEST[str_replace(".", "_", $row['icmp_ip'])])) {
					// List modified devices (name)
					$modified_hosts = $modified_hosts . $row['icmp_hostname'] . '; ';
					// Build sql query and update
					$sql_queue_str = implode(', ', $sql_queue);
					// Build Host list
					array_push($sql_modified_hosts, $row['icmp_ip']);
				}
			}
			// output modified hosts
			echo $modified_hosts;
			// List modifications
			echo '<h4>' . $pia_lang['Device_bulkEditor_savebox_mod_fields'] . ':</h4>';
			if (isset($set_bulk_owner)) {echo $pia_lang['DevDetail_MainInfo_Owner'] . ': ' . $set_bulk_owner . '<br>';}
			if (isset($set_bulk_type)) {echo $pia_lang['DevDetail_MainInfo_Type'] . ': ' . $set_bulk_type . '<br>';}
			if (isset($set_bulk_group)) {echo $pia_lang['DevDetail_MainInfo_Group'] . ': ' . $set_bulk_group . '<br>';}
			if (isset($set_bulk_location)) {echo $pia_lang['DevDetail_MainInfo_Location'] . ': ' . $set_bulk_location . '<br>';}
			if (isset($set_bulk_comments)) {echo $pia_lang['DevDetail_MainInfo_Comments'] . ': ' . $set_bulk_comments . '<br>';}
			if (isset($set_bulk_AlertAllEvents)) {echo $pia_lang['DevDetail_EveandAl_AlertAllEvents'] . ': ' . $set_bulk_AlertAllEvents . '<br>';}
			if (isset($set_bulk_AlertDown)) {echo $pia_lang['DevDetail_EveandAl_AlertDown'] . ': ' . $set_bulk_AlertDown . '<br>';}
			// Prepare Update Segment stop

			// Update Segment
			foreach ($sql_modified_hosts as $value) {
				$sql_update = 'UPDATE ICMP_Mon SET ' . $sql_queue_str . ' WHERE icmp_ip="' . $value . '"';
				$results_update = $db->query($sql_update);
			}

			// Logging
			pialert_logging('a_021', $_SERVER['REMOTE_ADDR'], 'LogStr_0002', '', $modified_hosts);
		}

		echo '<a href="./icmpmonitor.php?mod=bulkedit" class="btn btn-default pull-right" role="button" style="margin-bottom: 10px;">' . $pia_lang['Gen_Close'] . '</a>';
		print_box_bottom_element();
	}

	echo '<form method="post" action="./icmpmonitor.php">
          <input type="hidden" id="mod" name="mod" value="bulkedit">
          <input type="hidden" id="savedata" name="savedata" value="yes">';
	print_box_top_element($pia_lang['Device_bulkEditor_hostbox_title']);

	$sql = 'SELECT icmp_hostname, icmp_ip, icmp_PresentLastScan, icmp_AlertEvents, icmp_AlertDown FROM ICMP_Mon ORDER BY icmp_hostname COLLATE NOCASE ASC';
	$results = $db->query($sql);
	while ($row = $results->fetchArray()) {
		if ($row[2] == 1) {$status_border = 'bulked_online_border';} else { $status_border = 'bulked_offline_border';}
		if ($row[3] == 1 && $row[4] == 1) {$status_text_color = 'bulked_checkbox_label_alldown';} elseif ($row[3] == 1) {$status_text_color = 'bulked_checkbox_label_all';} elseif ($row[4] == 1) {$status_text_color = 'bulked_checkbox_label_down';} else { $status_text_color = '';}
		echo '<div class="bulked_dev_box ' . $status_border . '">
             <div class="bulked_dev_chk_cont" style="' . $status_box . '">
                <input class="icheckbox_flat-blue hostselection bulked_dev_chkbox" id="' . str_replace(".", "_", $row[1]) . '" name="' . str_replace(".", "_", $row[1]) . '" type="checkbox">
             </div>
             <label class="control-label ' . $status_text_color . '" for="' . str_replace(".", "_", $row[1]) . '" style="">' . $row[0] . '</label>
          </div>';
	}

	// Check/Uncheck All Button
	echo '<button type="button" class="btn btn-warning pull-right checkall" id="bulked_checkall">' . $pia_lang['Device_bulkEditor_selectall'] . '</button>';
	echo '<script>
            var clicked = false;
            $("#bulked_checkall").on("click", function() {
              $(".hostselection").prop("checked", !clicked);
              clicked = !clicked;
              this.innerHTML = clicked ? \'' . $pia_lang['Device_bulkEditor_selectnone'] . '\' : \'' . $pia_lang['Device_bulkEditor_selectall'] . '\';
            });
        </script>';
	print_box_bottom_element();

	print_box_top_element($pia_lang['Device_bulkEditor_inputbox_title']);
	// Inputs
	echo '<table style="margin-bottom:30px; width: 100%">
          <tr>
            <td class="bulked_table_cell_a" style="width: 80px;"><input class="icheckbox_flat-blue" id="en_bulk_owner" name="en_bulk_owner" type="checkbox"></td>
            <td>
                <label for="bulk_owner">' . $pia_lang['DevDetail_MainInfo_Owner'] . ':</label><br>
                <input type="text" class="form-control" id="bulk_owner" name="bulk_owner" style="max-width: 400px;" disabled></td>
          </tr>
          <tr>
            <td class="bulked_table_cell_a"><input class="icheckbox_flat-blue" id="en_bulk_type" name="en_bulk_type" type="checkbox"></td>
            <td>
                <label for="bulk_type">' . $pia_lang['DevDetail_MainInfo_Type'] . ':</label><br>
                <div class="input-group" style="max-width: 400px;">
                  <input class="form-control" id="bulk_type" name="bulk_type" type="text" disabled>
                  <div class="input-group-btn">
                    <button type="button" id="bulk_type_selector" name="bulk_type_selector" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-expanded="false" disabled>
                      <span class="fa fa-caret-down"></span></button>
                    <ul id="dropdownDeviceType" class="dropdown-menu dropdown-menu-right">
                      <li><a href="javascript:void(0)" onclick="setTextValue(\'bulk_type\',\'Smartphone\')">   Smartphone   </a></li>
                      <li><a href="javascript:void(0)" onclick="setTextValue(\'bulk_type\',\'Laptop\')">       Laptop       </a></li>
                      <li><a href="javascript:void(0)" onclick="setTextValue(\'bulk_type\',\'PC\')">           PC           </a></li>
                      <li><a href="javascript:void(0)" onclick="setTextValue(\'bulk_type\',\'Tablet\')">       Tablet       </a></li>
                      <li class="divider"></li>
                      <li><a href="javascript:void(0)" onclick="setTextValue(\'bulk_type\',\'Router\')">       Router       </a></li>
                      <li><a href="javascript:void(0)" onclick="setTextValue(\'bulk_type\',\'Switch\')">       Switch       </a></li>
                      <li><a href="javascript:void(0)" onclick="setTextValue(\'bulk_type\',\'Access Point\')"> Access Point </a></li>
                      <li class="divider"></li>
                      <li><a href="javascript:void(0)" onclick="setTextValue(\'bulk_type\',\'Others\')">       Others       </a></li>
                    </ul>
                  </div>
                </div>
            </td>
          </tr>
          <tr>
            <td class="bulked_table_cell_a"><input class="icheckbox_flat-blue" id="en_bulk_group" name="en_bulk_group" type="checkbox"></td>
            <td>
                <label for="bulk_group">' . $pia_lang['DevDetail_MainInfo_Group'] . ':</label><br>
                <div class="input-group" style="max-width: 400px;">
                  <input class="form-control" id="bulk_group" name="bulk_group" type="text" disabled>
                  <div class="input-group-btn">
                    <button type="button" id="bulk_group_selector" name="bulk_group_selector" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-expanded="false" disabled>
                      <span class="fa fa-caret-down"></span></button>
                    <ul id="dropdownGroup" class="dropdown-menu dropdown-menu-right">
                      <li><a href="javascript:void(0)" onclick="setTextValue(\'bulk_group\',\'Always On\')"> Always On </a></li>
                      <li><a href="javascript:void(0)" onclick="setTextValue(\'bulk_group\',\'Friends\')">   Friends   </a></li>
                      <li><a href="javascript:void(0)" onclick="setTextValue(\'bulk_group\',\'Personal\')">  Personal  </a></li>
                      <li class="divider"></li>
                      <li><a href="javascript:void(0)" onclick="setTextValue(\'bulk_group\',\'Others\')">    Others    </a></li>
                    </ul>
                  </div>
                </div>
            </td>
          </tr>
          <tr>
            <td class="bulked_table_cell_a"><input class="icheckbox_flat-blue" id="en_bulk_location" name="en_bulk_location" type="checkbox"></td>
            <td>
                <label for="bulk_location">' . $pia_lang['DevDetail_MainInfo_Location'] . ':</label><br>
                <div class="input-group" style="max-width: 400px;">
                  <input class="form-control" id="bulk_location" name="bulk_location" type="text" disabled>
                  <div class="input-group-btn">
                    <button type="button" id="bulk_location_selector" name="bulk_location_selector" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-expanded="false" disabled>
                      <span class="fa fa-caret-down"></span></button>
                    <ul id="dropdownLocation" class="dropdown-menu dropdown-menu-right">
                      <li><a href="javascript:void(0)" onclick="setTextValue(\'bulk_location\',\'Bathroom\')">    Bathroom</a></li>
                      <li><a href="javascript:void(0)" onclick="setTextValue(\'bulk_location\',\'Bedroom\')">     Bedroom</a></li>
                      <li><a href="javascript:void(0)" onclick="setTextValue(\'bulk_location\',\'Hall\')">        Hall</a></li>
                      <li><a href="javascript:void(0)" onclick="setTextValue(\'bulk_location\',\'Kitchen\')">     Kitchen</a></li>
                      <li><a href="javascript:void(0)" onclick="setTextValue(\'bulk_location\',\'Living room\')"> Living room</a></li>
                      <li class="divider"></li>
                      <li><a href="javascript:void(0)" onclick="setTextValue(\'bulk_location\',\'Others\')">      Others</a></li>
                    </ul>
                  </div>
                </div>
            </td>
          </tr>
          <tr>
            <td class="bulked_table_cell_a"><input class="icheckbox_flat-blue" id="en_bulk_comments" name="en_bulk_comments" type="checkbox"></td>
            <td>
                <label for="bulk_comments">' . $pia_lang['DevDetail_MainInfo_Comments'] . ':</label><br>
                <textarea class="form-control" rows="3" id="bulk_comments" name="bulk_comments" spellcheck="false" data-gramm="false" style="max-width: 400px;" disabled></textarea></td>
          </tr>
          <tr>
            <td class="bulked_table_cell_a"><input class="icheckbox_flat-blue" id="en_bulk_AlertAllEvents" name="en_bulk_AlertAllEvents" type="checkbox"></td>
            <td>
                <label for="bulk_AlertAllEvents" style="width: 200px;">' . $pia_lang['DevDetail_EveandAl_AlertAllEvents'] . ':</label>
                <input class="icheckbox_flat-blue" id="bulk_AlertAllEvents" name="bulk_AlertAllEvents" type="checkbox" disabled></td>
          </tr>
          <tr>
            <td class="bulked_table_cell_a"><input class="icheckbox_flat-blue" id="en_bulk_AlertDown" name="en_bulk_AlertDown" type="checkbox"></td>
            <td>
                <label for="bulk_AlertDown" style="width: 200px;">' . $pia_lang['DevDetail_EveandAl_AlertDown'] . ':</label>
                <input class="icheckbox_flat-blue" id="bulk_AlertDown" name="bulk_AlertDown" type="checkbox" disabled></td>
          </tr>

        </table>
        <button type="button" class="btn btn-danger" id="btnBulkDeletion" onclick="askBulkDeletion()" style="min-width: 180px;">' . $pia_lang['Device_bulkDel_button'] . '</button>
        <input class="btn btn-warning pull-right" type="submit" value="' . $pia_lang['Gen_Save'] . '" style="margin-bottom: 10px; min-width: 180px;">';

	// JS to enable/disable inputs. Inputs are delete, when disabled
	echo '<script>
            var bulk_owner = true;
            $("#en_bulk_owner").on("click", function() {
              $("#bulk_owner").val(\'\');
              $("#bulk_owner").prop("disabled", !bulk_owner);
              bulk_owner = !bulk_owner;
            });
            var bulk_type = true;
            $("#en_bulk_type").on("click", function() {
              $("#bulk_type").val(\'\');
              $("#bulk_type").prop("disabled", !bulk_type);
              $("#bulk_type_selector").prop("disabled", !bulk_type);
              bulk_type = !bulk_type;
            });
            var bulk_group = true;
            $("#en_bulk_group").on("click", function() {
              $("#bulk_group").val(\'\');
              $("#bulk_group").prop("disabled", !bulk_group);
              $("#bulk_group_selector").prop("disabled", !bulk_group);
              bulk_group = !bulk_group;
            });
            var bulk_location = true;
            $("#en_bulk_location").on("click", function() {
              $("#bulk_location").val(\'\');
              $("#bulk_location").prop("disabled", !bulk_location);
              $("#bulk_location_selector").prop("disabled", !bulk_location);
              bulk_location = !bulk_location;
            });
            var bulk_comments = true;
            $("#en_bulk_comments").on("click", function() {
              $("#bulk_comments").val(\'\');
              $("#bulk_comments").prop("disabled", !bulk_comments);
              bulk_comments = !bulk_comments;
            });
            var bulk_AlertAllEvents = true;
            $("#en_bulk_AlertAllEvents").on("click", function() {
              $("#bulk_AlertAllEvents").prop("checked", false);
              $("#bulk_AlertAllEvents").prop("disabled", !bulk_AlertAllEvents);
              bulk_AlertAllEvents = !bulk_AlertAllEvents;
            });
            var bulk_AlertDown = true;
            $("#en_bulk_AlertDown").on("click", function() {
              $("#bulk_AlertDown").prop("checked", false);
              $("#bulk_AlertDown").prop("disabled", !bulk_AlertDown);
              bulk_AlertDown = !bulk_AlertDown;
            });

            function setTextValue (textElement, textValue) {
              $("#"+textElement).val (textValue);
            }

            function askBulkDeletion() {
              // Ask
              showModalWarning(\'' . $pia_lang['Device_bulkDel_info_head'] . '\', \'' . $pia_lang['Device_bulkDel_info_text'] . '\',
                \'' . $pia_lang['Gen_Cancel'] . '\', \'' . $pia_lang['Gen_Delete'] . '\', \'BulkDeletion\');
            }
            function BulkDeletion()
            {
              const checkboxes = document.querySelectorAll(\'.icheckbox_flat-blue.hostselection:checked\');
              const checkedIds = Array.from(checkboxes).map((checkbox) => checkbox.id);
              const queryParams = new URLSearchParams();
              checkedIds.forEach((id) => queryParams.append(\'hosts[]\', id));
              // Execute
              $.get(\'php/server/icmpmonitor.php?action=BulkDeletion&\' + queryParams.toString(), function(msg) {
                showMessage (msg);
              });
            }

        </script>';

	print_box_bottom_element();

	echo '</form>';

	echo '</section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->';

	require 'php/templates/footer.php';
// ################### End Bulk-Editor #########################################
} else {
// ################### Start ICMP List #######################################
	?>

<!-- Content header--------------------------------------------------------- -->
    <section class="content-header">
    <?php require 'php/templates/notification.php';?>
      <h1 id="pageTitle">
         <?=$pia_lang['ICMPMonitor_Title'];?>
      <button type="button" class="btn btn-xs btn-success icmplist_add_ip" data-toggle="modal" data-target="#modal-add-monitoringIP"><i class="bi bi-plus-lg" style="font-size:1.5rem;"></i></button>
      </h1>

<!-- Modals New URL ----------------------------------------------------------------- -->

       <form role="form">
            <div class="modal fade" id="modal-add-monitoringIP">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span></button>
                            <h4 class="modal-title"><?=$pia_lang['ICMPMonitor_headline_IP'];?></h4>
                        </div>
                        <div class="modal-body">
                            <div style="height: 230px;">
                            <div class="form-group col-xs-12">
                              <label class="col-xs-3 control-label"><?=$pia_lang['ICMPMonitor_label_IP'];?></label>
                              <div class="col-xs-9">
                                <input type="text" class="form-control" id="icmphost_ip" placeholder="Host IP">
                              </div>
                            </div>
                            <div class="form-group col-xs-12">
                              <label class="col-xs-3 control-label"><?=$pia_lang['ICMPMonitor_label_Hostname'];?></label>
                              <div class="col-xs-9">
                                <input type="text" class="form-control" id="icmphost_name" placeholder="Hostname">
                              </div>
                            </div>
                            <div class="form-group col-xs-12">
                                <label class="col-xs-3 control-label"><?=$pia_lang['Device_TableHead_Favorite'];?></label>
                                <div class="col-xs-9" style="margin-top: 0px;">
                                  <input class="checkbox orange" id="insFavorite" type="checkbox">
                                </div>
                            </div>
                            <div class="form-group col-xs-12">
                                <label class="col-xs-3 control-label"><?=$pia_lang['WEBS_label_AlertEvents'];?></label>
                                <div class="col-xs-9" style="margin-top: 0px;">
                                  <input class="checkbox blue" id="insAlertEvents" type="checkbox">
                                </div>
                            </div>
                            <div class="form-group col-xs-12">
                                <label class="col-xs-3 control-label"><?=$pia_lang['WEBS_label_AlertDown'];?></label>
                                <div class="col-xs-9" style="margin-top: 0px;">
                                  <input class="checkbox red" id="insAlertDown" type="checkbox">
                                </div>
                            </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default pull-left" data-dismiss="modal"><?=$pia_lang['Gen_Close'];?></button>
                            <button type="button" class="btn btn-primary" id="btnInsert" onclick="insertNewICMPHost()" ><?=$pia_lang['Gen_Save'];?></button>
                        </div>
                    </div>
                </div>
            </div>
        </form>

    </section>

    <!-- Main content ---------------------------------------------------------- -->
    <section class="content">
      <div class="row">

<?php
function header_icmp_all($visibility, $header_all, $header_selected) {
	global $pia_lang;
	$layout = calc_header_size($header_all, $header_selected);
	if (strtolower($visibility) == 0) {$hide = "hide_element";} else {$hide = "";}
	echo '<div class="'.$layout['lg'].' '.$layout['md'].' '.$layout['sm'].' '.$hide.'">
        	<a href="#" onclick="javascript: getDevicesList(\'all\');">
          <div class="small-box bg-aqua">
            <div class="inner"><h3 id="devicesAll"> -- </h3><p class="infobox_label">'.$pia_lang['Device_Shortcut_AllDevices'].'</p></div>
            <div class="icon"><i class="fa fa-laptop text-aqua-40"></i></div>
          </div>
        </a>
        </div>';
}
function header_icmp_con($visibility, $header_all, $header_selected) {
	global $pia_lang;
	$layout = calc_header_size($header_all, $header_selected);
	if (strtolower($visibility) == 0) {$hide = "hide_element";} else {$hide = "";}
	echo '<div class="'.$layout['lg'].' '.$layout['md'].' '.$layout['sm'].' '.$hide.'">
          <a href="#" onclick="javascript: getDevicesList(\'connected\');">
          <div class="small-box bg-green">
            <div class="inner"><h3 id="devicesConnected"> -- </h3><p class="infobox_label">'.$pia_lang['Device_Shortcut_Connected'].'</p></div>
            <div class="icon"><i class="mdi mdi-lan-connect text-green-40"></i></div>
          </div>
          </a>
        </div>';
}
function header_icmp_fav($visibility, $header_all, $header_selected) {
	global $pia_lang;
	$layout = calc_header_size($header_all, $header_selected);
	if (strtolower($visibility) == 0) {$hide = "hide_element";} else {$hide = "";}
	echo '<div class="'.$layout['lg'].' '.$layout['md'].' '.$layout['sm'].' '.$hide.'">
          <a href="#" onclick="javascript: getDevicesList(\'favorites\');">
          <div class="small-box bg-yellow">
            <div class="inner"><h3 id="devicesFavorites"> -- </h3><p class="infobox_label">'.$pia_lang['Device_Shortcut_Favorites'].'</p></div>
            <div class="icon"><i class="fa fa-star text-yellow-40"></i></div>
          </div>
          </a>
        </div>';
}
function header_icmp_dnw($visibility, $header_all, $header_selected) {
	global $pia_lang;
	$layout = calc_header_size($header_all, $header_selected);
	if (strtolower($visibility) == 0) {$hide = "hide_element";} else {$hide = "";}
	echo '<div class="'.$layout['lg'].' '.$layout['md'].' '.$layout['sm'].' '.$hide.'">
          <a href="#" onclick="javascript: getDevicesList(\'down\');">
          <div class="small-box bg-red">
            <div class="inner"><h3 id="devicesDown"> -- </h3><p class="infobox_label">'.$pia_lang['Device_Shortcut_DownAlerts'].'</p></div>
            <div class="icon"><i class="mdi mdi-lan-disconnect text-red-40"></i></div>
          </div>
          </a>
        </div>';
}
function header_icmp_arc($visibility, $header_all, $header_selected) {
	global $pia_lang;
	$layout = calc_header_size($header_all, $header_selected);
	if (strtolower($visibility) == 0) {$hide = "hide_element";} else {$hide = "";}
	echo '<div class="'.$layout['lg'].' '.$layout['md'].' '.$layout['sm'].' '.$hide.'">
          <a href="#" onclick="javascript: getDevicesList(\'archived\');">
          <div class="small-box bg-gray top_small_box_gray_text">
            <div class="inner"><h3 id="devicesArchived"> -- </h3><p class="infobox_label">'.$pia_lang['Device_Shortcut_Archived'].'</p></div>
            <div class="icon"><i class="fa fa-eye-slash text-gray-40"></i></div>
          </div>
          </a>
        </div>';
}
$header_page_config = read_HeaderConfig();
$count_active_headers = count(array_filter($header_page_config['icmp'], function($value) {
    return $value == 1;
}));
header_icmp_all($header_page_config['icmp']['all'], sizeof($header_page_config['icmp']), $count_active_headers);
header_icmp_con($header_page_config['icmp']['con'], sizeof($header_page_config['icmp']), $count_active_headers);
header_icmp_fav($header_page_config['icmp']['fav'], sizeof($header_page_config['icmp']), $count_active_headers);
header_icmp_dnw($header_page_config['icmp']['dnw'], sizeof($header_page_config['icmp']), $count_active_headers);
header_icmp_arc($header_page_config['icmp']['arc'], sizeof($header_page_config['icmp']), $count_active_headers);
?>
      </div>

<!-- Activity Chart ------------------------------------------------------- -->

<?php
If ($ENABLED_HISTOY_GRAPH !== False) {
		?>
      <div class="row">
          <div class="col-md-12">
          <div class="box" id="clients">
              <div class="box-header with-border">
                <h3 class="box-title"><?=$pia_lang['Device_Shortcut_OnlineChart_a'];?><span class="maxlogage-interval">12</span> <?=$pia_lang['Device_Shortcut_OnlineChart_b'];?></h3>
              </div>
              <div class="box-body">
                <div class="chart">
                  <script src="lib/AdminLTE/bower_components/chart.js/Chart.js"></script>
                  <canvas id="OnlineChart" style="width:100%; height: 150px;  margin-bottom: 15px;"></canvas>
                </div>
              </div>
            </div>
          </div>
      </div>

      <script src="js/graph_online_history.js"></script>
      <script>
        var online_history_time = [<?php pia_graph_devices_data($Graph_Device_Time);?>];
        var online_history_ondev = [<?php pia_graph_devices_data($Graph_Device_Online);?>];
        var online_history_dodev = [<?php pia_graph_devices_data($Graph_Device_Down);?>];
        var online_history_ardev = [<?php pia_graph_devices_data($Graph_Device_Arch);?>];
        graph_online_history_icmp(online_history_time, online_history_ondev, online_history_dodev, online_history_ardev);
      </script>
<?php
}
	?>
      <div class="row">
        <div class="col-xs-12">
          <div id="tableDevicesBox" class="box">

            <!-- box-header -->
            <div class="box-header">
              <h3 id="tableDevicesTitle" class="box-title text-aqua"><?=$pia_lang['Device_Title'];?></h3>
              <a href="./icmpmonitor.php?mod=bulkedit" class="btn btn-xs btn-default" role="button" style="display: inline-block; margin-top: -5px; margin-left: 15px;"><i class="fa fa-pencil" style="font-size:1.5rem"></i></a>
            </div>

            <div class="box-body table-responsive">
              <table id="tableDevices" class="table table-bordered table-hover table-striped">
                <thead>
                <tr>
                  <th><?=$pia_lang['Device_TableHead_Name']?></th>
                  <th>IP</th>
                  <th><?=$pia_lang['Device_TableHead_Favorite']?></th>
                  <th><?=$pia_lang['WEBS_EVE_TableHead_ResponsTime']?></th>
                  <th style="white-space: nowrap;"><?=$pia_lang['WEBS_tablehead_ScanTime']?></th>
                  <th><?=$pia_lang['Device_TableHead_Status']?></th>
                  <th>row6</th>
                  <th>row7</th>
                  <th>RowID</th>
                </tr>
                </thead>
              </table>
            </div>
            <!-- /.box-body -->

          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->

    <div style="width: 100%; height: 20px;"></div>
    <!-- ----------------------------------------------------------------------- -->

    </section>
  </div>
  <!-- /.content-wrapper -->

<!-- ----------------------------------------------------------------------- -->

<?php
require 'php/templates/footer.php';
	?>

<script src="lib/AdminLTE/plugins/iCheck/icheck.min.js"></script>
<link rel="stylesheet" href="lib/AdminLTE/plugins/iCheck/all.css">
<link rel="stylesheet" href="lib/AdminLTE/bower_components/datatables.net-bs/css/dataTables.bootstrap.min.css">
<script src="lib/AdminLTE/bower_components/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="lib/AdminLTE/bower_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>

<script>
	var deviceStatus = 'all';
  var parTableRows    = 'Front_Devices_Rows';
  var parTableOrder   = 'Front_Devices_Order';
  var tableRows       = 10;
	main();

// -----------------------------------------------------------------------------
function initializeiCheck () {
   // Blue
   $('input[type="checkbox"].blue').iCheck({
     checkboxClass: 'icheckbox_flat-blue',
     radioClass:    'iradio_flat-blue',
     increaseArea:  '20%'
   });
  // Orange
  $('input[type="checkbox"].orange').iCheck({
    checkboxClass: 'icheckbox_flat-orange',
    radioClass:    'iradio_flat-orange',
    increaseArea:  '20%'
  });
  // Red
  $('input[type="checkbox"].red').iCheck({
    checkboxClass: 'icheckbox_flat-red',
    radioClass:    'iradio_flat-red',
    increaseArea:  '20%'
  });
}

// -----------------------------------------------------------------------------
// function main () {
//     initializeiCheck();
//     initializeDatatable();
//     getDevicesList (deviceStatus);
//     getICMPHostTotals();
// }

function main () {
  // get parameter value
  $.get('php/server/parameters.php?action=get&parameter='+ parTableRows, function(data) {
    var result = JSON.parse(data);
    if (Number.isInteger (result) ) {
        tableRows = result;
    }

    // get parameter value
    $.get('php/server/parameters.php?action=get&parameter='+ parTableOrder, function(data) {
      var result = JSON.parse(data);
      result = JSON.parse(result);
      if (Array.isArray (result) ) {
        tableOrder = result;
      }
      // Initialize components with parameters
      initializeDatatable();
      // query data
      getICMPHostTotals()
      getDevicesList (deviceStatus);
     });
   });
  initializeiCheck();
}

// -----------------------------------------------------------------------------
function initializeDatatable () {
  var table=
  $('#tableDevices').DataTable({
    'paging'       : true,
    'lengthChange' : true,
    'lengthMenu'   : [[10, 25, 50, 100, 500, -1], [10, 25, 50, 100, 500, '<?=$pia_lang['Device_Tablelenght_all'];?>']],
    'searching'    : true,
    'ordering'     : true,
    'info'         : true,
    'autoWidth'    : false,
    'order'       : [[0,'asc']],

    // Parameters
    'pageLength'   : tableRows,

    'columnDefs'   : [
      {visible:   false,         targets: [6,7,8] },
      {className: 'text-center', targets: [1,2,3,4,5] },
      {className: 'text-left',   targets: [0] },
      {width:     '150px',       targets: [4] },
      {width:     '80px',        targets: [2,5] },
      {width:     '110px',       targets: [3] },

      {targets: [0],
        'createdCell': function (td, cellData, rowData, row, col) {
	          switch (rowData[7]) {
	            case 'Down':      color='red';                 break;
	            case 'OnlineV':   color='#00A000';             break;
	            case 'Online':    color='#00A000';             break;
	            case 'Offline':   color='transparent';         break;
	            default:          color='transparent';         break;
	          };
            $(td).html ('<b><a href="icmpmonitorDetails.php?hostip='+ rowData[1] +'" class="">'+ cellData +'</a></b>');
            $(td).css('min-width', '160px');

            let tableWidth = $("#tableDevices").outerWidth();
            let viewportWidth = $(window).width() - 50;

            if (tableWidth > viewportWidth) {
                $(td).css({
                    "border-left": `2px solid ${color}`,
                    "padding-left": "8px"
                });
            } else {
            	  $(td).css({
            	  	  "border-left": "",
            	  	  "padding-left": ""
            	  });
            }
      } },
      {targets: [2],
        'createdCell': function (td, cellData, rowData, row, col) {
          if (cellData == 1){
            $(td).html ('<i class="fa fa-star text-yellow" style="font-size:16px"></i>');
          } else {
            $(td).html ('');
          }
      } },
      {targets: [3],
        'createdCell': function (td, cellData, rowData, row, col) {
          if (cellData == 99999){
            $(td).html ('TimeOut');
          } else {
            $(td).html (cellData + ' ms');
          }
      } },
      {targets: [5],
        'createdCell': function (td, cellData, rowData, row, col) {
          switch (rowData[7]) {
            case 'Down':     color='red';                 statusname='Down';                          break;
            case 'OnlineV':  color='green';               statusname='Online*';                       break;
            case 'Online':   color='green';               statusname='Online';                        break;
            case 'Offline':  color='gray text-white';     statusname='Offline';                       break;
            default:         color='aqua';                statusname=''; 					                   break;
          };
          $(td).html ('<a href="icmpmonitorDetails.php?hostip='+ rowData[1] +'" class="badge bg-'+ color +'">'+ statusname +'</a>');
      } },
    ],

    // Processing
    'processing'  : true,
    'language'    : {
      processing: '<table> <td width="130px" align="middle">Loading...</td><td><i class="ion ion-ios-sync fa-spin fa-2x fa-fw"></td> </table>',
      emptyTable: 'No data',
      "lengthMenu": "<?=$pia_lang['Device_Tablelenght'];?>",
      "search":     "<?=$pia_lang['Device_Searchbox'];?>: ",
      "paginate": {
          "next":       "<?=$pia_lang['Device_Table_nav_next'];?>",
          "previous":   "<?=$pia_lang['Device_Table_nav_prev'];?>"
      },
      "info":           "<?=$pia_lang['Device_Table_info'];?>",
    }
  });
};

// -----------------------------------------------------------------------------
function getDevicesList(status) {
  // Save status selected
  deviceStatus = status;

  // Define color & title for the status selected
  switch (deviceStatus) {
    case 'all':        tableTitle = '<?=$pia_lang['Device_Shortcut_AllDevices']?>';  color = 'aqua';    break;
    case 'connected':  tableTitle = '<?=$pia_lang['Device_Shortcut_Connected']?>';   color = 'green';   break;
    case 'favorites':  tableTitle = '<?=$pia_lang['Device_Shortcut_Favorites']?>';   color = 'yellow';  break;
    case 'down':       tableTitle = '<?=$pia_lang['Device_Shortcut_DownAlerts']?>';  color = 'red';     break;
    case 'archived':   tableTitle = '<?=$pia_lang['Device_Shortcut_Archived']?>';    color = 'gray';    break;
    default:           tableTitle = '<?=$pia_lang['Device_Shortcut_AllDevices']?>';  color = 'aqua';    break;
  }

  // Set title and color
  $('#tableDevicesTitle')[0].className = 'box-title text-'+ color;
  $('#tableDevicesBox')[0].className = 'box box-'+ color;
  $('#tableDevicesTitle').html (tableTitle);

  // Define new datasource URL and reload
  $('#tableDevices').DataTable().ajax.url(
    'php/server/icmpmonitor.php?action=getDevicesList&status=' + deviceStatus).load();
};

// -----------------------------------------------------------------------------
function getICMPHostTotals () {
  $.get('php/server/icmpmonitor.php?action=getICMPHostTotals', function(data) {
    var totalsDevices = JSON.parse(data);

    $('#devicesAll').html        (totalsDevices[0].toLocaleString());
    $('#devicesConnected').html  (totalsDevices[2].toLocaleString());
    $('#devicesFavorites').html  (totalsDevices[3].toLocaleString());
    $('#devicesDown').html       (totalsDevices[1].toLocaleString());
    $('#devicesArchived').html   (totalsDevices[4].toLocaleString());
} );
};

// -----------------------------------------------------------------------------
function insertNewICMPHost(refreshCallback='') {
  // Check URL
  if ($('#icmp_ip').val() == '') {
    return;
  }

  // update data to server
  $.get('php/server/icmpmonitor.php?action=insertNewICMPHost'
    + '&icmp_ip='         + $('#icmphost_ip').val()
    + '&icmp_hostname='   + $('#icmphost_name').val()
    + '&icmp_fav='        + ($('#insFavorite')[0].checked * 1)
    + '&alertdown='       + ($('#insAlertDown')[0].checked * 1)
    + '&alertevents='     + ($('#insAlertEvents')[0].checked * 1)
    , function(msg) {

    // deactivate button
    // deactivateSaveRestoreData ();
    showMessage (msg);
    // Callback fuction
    if (typeof refreshCallback == 'function') {
      refreshCallback();
    }
  });
}

</script>

<?php
}
// ################### End ICMP List #########################################
?>
