## Checking and troubleshooting 

<hr>

### The browser shows a pop-up with an error when loading the page

This can have several causes. One is an outdated browser cache. Delete this if necessary. 

Furthermore, an invalid character can also lead to an incorrect JSON being generated by the backend. Since 
JSONs must correspond to a specific schema and many parts in Pi.Alert exchange data in JSON format, this can 
lead to errors. The "Test Main JSON Calls" function is available for this purpose under Maintenance -> Settings -> Advanced. 
If you report an issue in this regard, please include the output of this function.

<hr>

### Repairing an installation after a failed update

1. rename the still existing "pialert" directory e.g. to "pialert-old"
2. reinstall Pi.Alert
3. copy the database from "pialert-old/db" to "pialert/db/" and overwrite the existing database there
4. copy "pialert.conf" from "pialert-old/config" to "pialert/config"
5. execute the command "./pialert-cli set_permissions" in the "pialert/back" directory
6. now everything should work again

<hr>

### Repairing an installation after a system (os) update

After an operating system update, there is a high probability that Pi.Alert will no longer function, 
as essential components of the system have changed. Most problems can usually be resolved by running the update script again. 
In some cases, however, incompatibilities may arise, which I would address if possible.

<hr>

### Broken Scan after Pi-hole update from 5.x to 6.x

```
Scanning...
    arp-scan Method...
        ...arp-scan: One interface
    Pi-hole 5 Client List Method...
Traceback (most recent call last):
  File "/home/user/pialert/back/pialert.py", line 4195, in <module>
    sys.exit(main())
             ^^^^^^
  File "/home/user/pialert/back/pialert.py", line 102, in main
    res = scan_network()
          ^^^^^^^^^^^^^^
  File "/home/user/pialert/back/pialert.py", line 825, in scan_network
    copy_pihole_network()
  File "/home/user/pialert/back/pialert.py", line 1018, in copy_pihole_network
    copy_pihole_network_five()
  File "/home/user/pialert/back/pialert.py", line 1028, in copy_pihole_network_five
    sql.execute ("ATTACH DATABASE '"+ PIHOLE_DB +"' AS PH")
sqlite3.OperationalError: unable to open database: /etc/pihole/pihole-FTL.db
```

This is a normal error under these circumstances. This is because Pi.Alert uses different functions for these two different versions. 
The correct PiHole version must be specified in the Pi.Alert configuration. You can find out how to do this in the documentation of 
the configuration file [pialert.conf](./PIALERT_CONF.md).

<hr>

### Broken Pi.Alert Webinterface after Pi-hole update from 5.x to 6.x

During the Pi-hole 6.x update, you were asked if you wanted to deactivate the web server that Pi-hole used before. 

<img width="570" alt="Image" src="https://github.com/user-attachments/assets/215cde72-6537-46df-b148-fd83da6b7b67" />

If you confirmed this, you also deactivated the Pi.Alert web interface at that moment. To reactivate this, Pi-hole must be reconfigured, as both web 
interfaces can no longer run on one port (default 80). You can use this script for this.

[pihole6_port_conflict.sh](https://raw.githubusercontent.com/leiweibau/Pi.Alert/refs/heads/main/install/pihole6_port_conflict.sh)

You can also find the script in the directory “pialert/install/” in versions greater than Pi.Alert v2025-03-21

<hr>

### I get a message like: RequestsDependencyWarning: urllib3 (2.4.0) or chardet (5.1.0)/charset_normalizer (3.0.1) doesn't match a supported version!

In this case you should update the existing python package. You can do this with the following command.

```
pip3 -q install "requests>=2.31.0" --break-system-packages
```

Depending on the distribution used, you may not need the “--break-system-packages” parameter

<hr>

[Back](https://github.com/leiweibau/Pi.Alert)
